import flixel.text.FlxText;
import flixel.text.FlxTextAlign;
import lime.graphics.Image;
import flixel.ui.FlxBar;
import funkin.backend.MusicBeatState;
MusicBeatState.skipTransIn = MusicBeatState.skipTransOut = true;

var pixelNotesForBF = true;
var pixelNotesForDad = true;
var pixelSplashes = true;
var scr:FlxText;
maxHealth = 0.4;


// the count dowm
var fmcountdown:FlxSprite = new FlxSprite(594, 162);
fmcountdown.frames = Paths.getFrames("game/hud/funkmix/fmcount");
fmcountdown.animation.addByPrefix("3", "fmcount 3", 0, false);
fmcountdown.animation.addByPrefix("2", "fmcount 2", 0, false);
fmcountdown.animation.addByPrefix("1", "fmcount 1", 0, false);
fmcountdown.animation.addByPrefix("go", "fmcount go", 0, false);
fmcountdown.scale.set(6, 6);
fmcountdown.antialiasing = false;

// the ratings s
var fmrating:FlxSprite = new FlxSprite(780, 340);
fmrating.frames = Paths.getFrames("game/hud/funkmix/fmratings");
fmrating.animation.addByPrefix("fmmiss", "fmmiss", 0, false);
fmrating.animation.addByPrefix("fmshit", "fmshit", 0, false);
fmrating.animation.addByPrefix("fmbad", "fmbad", 0, false);
fmrating.animation.addByPrefix("fmgood", "fmgood", 0, false);
fmrating.animation.addByPrefix("fmsick", "fmsick", 0, false);
fmrating.scale.set(6, 6);
fmrating.antialiasing = false;


var weegeeBarBorder = new FlxSprite(915, 24);
weegeeBarBorder.loadGraphic("images/game/hud/funkmix/Health_Bar.png");
weegeeBarBorder.scale.set(6, 6);
var weegeeBar:FlxBar;
weegeeBar = new FlxBar(837, 0, FlxBar.LEFT_TO_RIGHT, 204, 24, this, 'health', 0, 0.4);
weegeeBar.numDivisions = 20;
weegeeBar.createFilledBar(0xFF000000, 0xFFFFFFFF);
weegeeBar.flipX = true;

window.title = "Funk Mix: YTP Invasion";
window.setIcon(Image.fromBytes(Assets.getBytes(Paths.image('stages/funkmix/icon'))));

//THE SQUIDS

var squid1:FlxSprite = new FlxSprite(168, 382);
squid1.frames = Paths.getFrames("stages/funkmix/blooper");
squid1.animation.addByPrefix("floating", "blooper bloops", 3, false);
squid1.scale.set(6, 6);
squid1.antialiasing = false;
var squid2:FlxSprite = new FlxSprite(480, 292);
squid2.frames = Paths.getFrames("stages/funkmix/blooper");
squid2.animation.addByPrefix("floating", "blooper bloops", 3, false);
squid2.scale.set(6, 6);
squid2.antialiasing = false;


var beep1:FlxSound;
beep1 = FlxG.sound.load(Paths.sound("funkmix/countdown"));
var beep2:FlxSound;
beep2 = FlxG.sound.load(Paths.sound("funkmix/countdownend"));

function postCreate() {

	PlayState.instance.healthBarBG.visible = PlayState.instance.healthBar.visible = PlayState.instance.iconP1.visible = PlayState.instance.iconP2.visible = PlayState.instance.accuracyTxt.visible = PlayState.instance.scoreTxt.visible = PlayState.instance.missesTxt.visible = PlayState.instance.comboGroup.visible = false;
	GameOverSubstate.script = 'data/scripts/gameovers/funkmix';
	PlayState.instance.playerStrums(2000, -100);
	FlxG.camera.follow(underwater);
	
	(scr = new FunkinText(140, 0, 0, PlayState.instance.songScore, 30));
	scr.setFormat(Paths.font('soretro.ttf'), 48, 0xFFFFFFFF);
  
    if (downscroll) {
		scr.y = 0;
		weegeeBarBorder.y = 24;
		FlxG.camera.targetOffset.set(0, -70);
	} else {
        scr.y = 550;
		weegeeBarBorder.y = 572;
		FlxG.camera.targetOffset.set(0, -172);
	}
	FlxG.camera.snapToTarget();
	fmrating.visible = false;
	add(scr);
	weegeeBar.y = weegeeBarBorder.y-12;
	add(weegeeBar);
	add(weegeeBarBorder);
	add(fmrating);
	
	add(squid1);
	add(squid2);

	fmcountdown.visible = false;
	add(fmcountdown);
    
	cpuStrums.forEach(function(e)
		{
			FlxTween.cancelTweensOf(e);
			e.alpha = 1;
		});
	playerStrums.forEach(function(a)
		{
			FlxTween.cancelTweensOf(a);
			a.alpha = 1;
		});
}

//the notes
function onNoteCreation(event) {
	if (event.note.strumLine == playerStrums && !pixelNotesForBF) return;
	if (event.note.strumLine == cpuStrums && !pixelNotesForDad) return;

	event.cancel();

	var note = event.note;
	if (event.note.isSustainNote) {
		note.loadGraphic(Paths.image('game/notes/funkmix/arrowEnds'), true, 7, 6);
		note.animation.add("hold", [event.strumID]);
		note.animation.add("holdend", [4 + event.strumID]);
	} else {
		note.loadGraphic(Paths.image('game/notes/funkmix/arrows'), true, 17, 17);
		note.animation.add("scroll", [4 + event.strumID]);
	}
	note.scale.set(6, 6);
	note.updateHitbox();
}

function onPostNoteCreation(event) {  
    var splashes = event.note;
	if (pixelSplashes) splashes.splash = "funkmix-splash";
	if (event.note.isSustainNote) event.note.alpha = 1;
}


function onStrumCreation(event) {
	if (event.player == 1 && !pixelNotesForBF) return;
	if (event.player == 0 && !pixelNotesForDad) return;

	event.cancel();

	var strum = event.strum;
	strum.loadGraphic(Paths.image('game/notes/funkmix/arrows'), true, 17, 17);
	strum.animation.add("static", [event.strumID]);
	strum.animation.add("pressed", [4 + event.strumID, 8 + event.strumID], 12, false);
	strum.animation.add("confirm", [12 + event.strumID, 16 + event.strumID], 24, false);

	strum.scale.set(6, 6);
	strum.updateHitbox();
}


//custom countdown
function onCountdown(event) {
	event.soundPath = null;
	event.spritePath = null;
	switch(event.swagCounter) {
		case 0: 
			beep1.play(true);
			fmcountdown.visible = true;
			fmcountdown.animation.play('3');
		case 1: 
			beep1.play(true);
            fmcountdown.animation.play('2');
		case 2: 
			beep1.play(true);
			fmcountdown.animation.play('1');
		case 3: 	
		    beep2.play(true);
			fmcountdown.animation.play('go');
		case 4: 
		    fmcountdown.destroy();
		    remove(fmcountdown);

			
	};
}
function onDadHit(event) {
	//if (!event.note.isSustainNote)
	//	if (health > 0.1) event.healthGain += 0.02;
}
function onPlayerHit(event:NoteHitEvent) {
	if (!event.note.isSustainNote) {
			
		switch (event.rating)
		{
			case 'sick':
				fmrating.animation.play('fmsick');
			case 'good':
				fmrating.animation.play('fmgood');
			case 'bad':
				fmrating.animation.play('fmbad');
			case 'shit':
				fmrating.animation.play('fmshit');
		}
		ratingAnimation();
	}
	
}
function onPlayerMiss(event) {
	if (!event.note.isSustainNote) {
		fmrating.animation.play('fmmiss');
		ratingAnimation();	
	
	}	
}

function ratingAnimation() {		
	FlxTween.cancelTweensOf(fmrating);
	fmrating.y = 340;
	fmrating.visible = true;
	FlxTween.tween(fmrating, {y: 160}, 0.7, {
		onComplete: function()
			{
				fmrating.visible = false;
			}
		});

}





function beatHit(beat)
	{			
		if (beat == -3) bloopup1();
		if (beat == -4) bloopup2();
	}

function bloopup1() {
    trace("bloop1 ?");
	FlxTween.cancelTweensOf(squid1);
	squid1.animation.play('floating');
	FlxTween.tween(squid1, {y: 272}, 0.6, {
		onComplete: function() FlxTween.tween(squid1, {y: 382}, 1.25, {
			onComplete: function() bloopup1() })});

}

function bloopup2() {
	trace("bloop2 ?");
	FlxTween.cancelTweensOf(squid2);
	squid2.animation.play('floating');
	FlxTween.tween(squid2, {y: 182}, 0.6, {
		onComplete: function() FlxTween.tween(squid2, {y: 292}, 1.25, {
			onComplete: function() bloopup2() })});

}


function postUpdate(elapsed)
	{
        
		camZooming = false;
		weegeeBar.value = health;
		
		//update score text
		if (scr != null)
			scr.text = PlayState.instance.songScore;
		switch (scr.text.length)
		{
			case 1:
				scr.text = "00000" + scr.text;
			case 2:
				scr.text = "0000" + scr.text;
			case 3:
				scr.text = "000" + scr.text;
			case 4:
				scr.text = "00" + scr.text;
			case 5:
				scr.text = "0" + scr.text;
		}

	}
function onSongEnd() if (skipTransition) skipTransition = false;
	